<?php
// app/Models/ProjectCode.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProjectCode extends Model
{
    use HasFactory;

    protected $table = 'project_codes';

    protected $fillable = [
        'project_name',
        'description',
        'price'
    ];

    protected $casts = [
        'price' => 'decimal'
    ];

    // Relationship with time_sheets (if you want to connect them)
    public function timeSheets()
    {
        return $this->hasMany(TimeSheet::class, 'project_code', 'project_code');
    }
}